-- KrAZ-6322 Truck by Currenthill

-- Chassis
GT_t.CH_t.KrAZ6322 = {	
	life = 2,
	mass = 12500,
	length = 9.1,
	width = 2.72,
	max_road_velocity = 22.2,
	max_slope = 0.4,
	fordingDepth = 1.2,
	max_vert_obstacle = 0.5,
	max_acceleration = 1.2,
	min_turn_radius = 10.5,	
	engine_power = 330,
	engineMinRPM = 600,
	engineMaxPowerRPM = 2200,
	engineMaxRPM = 2400,
	gearRatios = { -5.03, 0.0, 3.49, 1.86, 1.41, 1.00, 0.75},
	mainGearRatio = 7.2,
	automaticTransmission = false,		
	X_gear_1 = 3.47,
	Y_gear_1 = 0,
	Z_gear_1 = 1.12,
	X_gear_2 = -2.9,
	Y_gear_2 = 0,
	Z_gear_2 = -1.12,
	gear_type = GT_t.GEAR_TYPES.WHEELS,
	r_max = 0.61,
	armour_thickness = 0.001,	
}

GT = {};
GT_t.ws = 0;
set_recursive_metatable(GT, GT_t.generic_wheel_vehicle);
set_recursive_metatable(GT.chassis, GT_t.CH_t.KrAZ6322);
set_recursive_metatable(GT.armour_scheme, GT_t.unarmed_armour_scheme);

GT.visual.shape = "KrAZ6322";
GT.visual.shape_dstr = "KrAZ6322-dest";

GT.toggle_alarm_state_interval = 1.0;

GT.IR_emission_coeff = 0.08
GT.visual.IR = { coeffs = {GT_t.IR_COEFFS_ENGINE_APC, GT_t.IR_COEFFS_WHEELS_Car, {0, 0}, IR_COEFFS_BODY, {0.18, 0.18/800}}}

-- Turbine
GT.turbine = false;

-- Chassis
GT.swing_on_run = false;

GT.sensor = {};
set_recursive_metatable(GT.sensor, GT_t.SN_visual);
GT.sensor.height = 3.0;

-- Burning after hit
GT.visual.fire_size = 0.6; --relative burning size
GT.visual.fire_pos[1] = 2.9; -- center of burn at long axis shift(meters)
GT.visual.fire_pos[2] = 1.3; -- center of burn shift at vertical shift(meters)
GT.visual.fire_pos[3] = 0; -- center of burn at transverse axis shift(meters)
GT.visual.fire_time = 1000; --burning time (seconds)
GT.visual.dust_pos = {1.12, 0.05, 0}
GT.visual.dirt_pos = {-1.12, 0.05, 0}

GT.visual.min_time_agony       = 5
GT.visual.max_time_agony       = 120
GT.visual.agony_explosion_size = 5

GT.driverViewConnectorName = {"POINT_DRIVER_01", offset = {0.0, -0.0, 0.0}}
GT.driverCockpit = "DriverCockpit/DriverCockpitWithIRandLLTV"

-- ================================================================================================================================

GT.Name = "CH_KrAZ6322";
GT.DisplayName = _("[CH] KrAZ-6322 Truck");
GT.DisplayNameShort = _('KrAZ-6322');
GT.Rate = 10;

GT.Sensors = { 
	Mount_WS_ID = 1,
	OPTIC = {"TKN-3B day", "TKN-3B night",
                        },
	noVisualDetectorInAlarmedState = false							
            };
		
GT.InternalCargo = {
    nominalCapacity = 2400,
    maximalCapacity = 2400,
}

GT.DetectionRange = 0;
GT.airWeaponDist = 0
GT.ThreatRange = 0;
GT.mapclasskey = "P0091000005";
GT.attribute = {wsType_Ground,wsType_Tank,wsType_NoWeapon,WSTYPE_PLACEHOLDER,
                "Trucks",
                };
GT.category = "Unarmed";

GT.tags  =
{
    "Unarmed",
    "Support & Logistics",
}

GT.warehouse = true
GT.Countries = {"Ukraine"}

